/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of the Hex Edit control

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-07-04  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file HexEdit.h
///  Definition file of the Hex Edit control
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////////////////
/// Edit Control supporting hexadecimal entries
///////////////////////////////////////////////////////////////////////////////////////////
class CHexEdit : public CEdit
{
	DECLARE_DYNAMIC(CHexEdit)

public:
	CHexEdit();
	virtual ~CHexEdit();

protected:
	DECLARE_MESSAGE_MAP()

  bool                        m_fDisplayHex;          //!< true if value is displayed in hexadecimal notation
  unsigned long               m_ulHexWidth;           //!< Width of the hexadecimal notation

  bool                        m_fForceHexConversion;  //!< Force inputs to be handled as hexadecimal
  unsigned long               m_ulValue;              //!< Current value of the control
  __unaligned uint32_t*       m_pulValue;             //!< Pointer to a variable receiving updated values

public:
  afx_msg void OnEnChange();
  void         Update(void);

  bool GetViewStyle(void)
  {
    return m_fDisplayHex;
  }

  void  SetViewStyle(bool fHex = true)
  {
    m_fDisplayHex = fHex;
    Update();
  }

  unsigned long GetHexWidth(void)
  {
    return m_ulHexWidth;
  }

  void SetHexWidth(unsigned long ulNewWidth)
  {
    m_ulHexWidth = ulNewWidth;
    Update();
  }

  unsigned long GetValue(void)
  {
    return m_ulValue;
  }

  void SetValue(unsigned long ulNewValue)
  {
    m_ulValue = ulNewValue;
    if(m_pulValue != NULL)
      *m_pulValue = ulNewValue;
    Update();
  }

  void SetUpdateVariable(__unaligned uint32_t* pulVarToSet)
  {
    m_pulValue = pulVarToSet;
    SetValue(m_ulValue);
  }

  afx_msg void OnEnKillfocus();
};


